/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.empreintes;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatEmpreinteFichier;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class GenererEmpreinteFichier {
    private static Logger log = Logger.getLogger(GenererEmpreinteFichier.class);

    public static Resultat traitementP11(PKCS11 pKCS11, long l, long l2, FileInputStream fileInputStream) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                if (fileInputStream != null) {
                    ResultatEmpreinteFichier resultatEmpreinteFichier;
                    block16: {
                        boolean bl;
                        byte[] byArray;
                        block15: {
                            resultatEmpreinteFichier = new ResultatEmpreinteFichier("G\u00e9n\u00e9ration de l'empreinte d'un fichier avec " + TraitementsUtil.getNomAlgo(l2) + " (Initialisation (C_DigestInit))", "G\u00e9n\u00e9ration de l'empreinte d'un fichier avec " + TraitementsUtil.getNomAlgo(l2) + " (G\u00e9n\u00e9ration (C_DigestUpdate))", "G\u00e9n\u00e9ration de l'empreinte d'un fichier avec " + TraitementsUtil.getNomAlgo(l2) + " (Finalisation (C_DigestFinal))");
                            CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
                            cK_MECHANISM.mechanism = l2;
                            byArray = null;
                            bl = false;
                            try {
                                pKCS11.C_DigestInit(l, cK_MECHANISM);
                            }
                            catch (PKCS11Exception pKCS11Exception) {
                                log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                                resultatEmpreinteFichier.setCodeRetour(pKCS11Exception.getErrorCode());
                                bl = true;
                                resultatEmpreinteFichier.setCodeRetour2(-1L);
                                resultatEmpreinteFichier.appendOperation2(" NON EXECUTEE!");
                                resultatEmpreinteFichier.setCodeRetour3(-1L);
                                resultatEmpreinteFichier.appendOperation3(" NON EXECUTEE!");
                            }
                            try {
                                if (bl) break block15;
                                int n = 0;
                                boolean bl2 = false;
                                int n2 = 1024;
                                while (!bl2) {
                                    n = 0;
                                    byte[] byArray2 = new byte[n2];
                                    n = fileInputStream.read(byArray2, 0, n2);
                                    if (n != -1) {
                                        pKCS11.C_DigestUpdate(l, byArray2);
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (IOException iOException) {
                                log.error((Object)("Probleme d'entree/sortie\n" + iOException.getMessage()));
                                bl = true;
                                resultatEmpreinteFichier.setCodeRetour3(-1L);
                                resultatEmpreinteFichier.appendOperation3(" NON EXECUTEE!");
                            }
                            catch (PKCS11Exception pKCS11Exception) {
                                log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                                resultatEmpreinteFichier.setCodeRetour2(pKCS11Exception.getErrorCode());
                                bl = true;
                                resultatEmpreinteFichier.setCodeRetour3(-1L);
                                resultatEmpreinteFichier.appendOperation3(" NON EXECUTEE!");
                            }
                        }
                        try {
                            if (bl) break block16;
                            byArray = pKCS11.C_DigestFinal(l);
                            if (byArray != null) {
                                resultatEmpreinteFichier.setEmpreinte(TraitementsUtil.getHexadecimal(byArray, null));
                                break block16;
                            }
                            log.error((Object)"L'operation a retourne une empreinte nulle");
                            throw new ExceptionTraitement(27, "L'op\u00e9ration a retourn\u00e9 une empreinte nulle");
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                            resultatEmpreinteFichier.setCodeRetour3(pKCS11Exception.getErrorCode());
                        }
                    }
                    return resultatEmpreinteFichier;
                }
                log.error((Object)"Le fichier est illisible");
                throw new ExceptionTraitement(27, "Le fichier est illisible");
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(27, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(27, "Une erreur inattendue est survenue");
        }
    }
}

